#include <algorithm>
#include <cstdint>
#include <iostream>
#include <vector>

using namespace std;

bool printing = false;

struct BeforeAfter {
    int before = -1;
    int after = -1;
};

struct Coordinate {
    int x;
    int y;
    int index;

    bool operator< (const Coordinate &other) const {
        if (!printing) return x < other.x;
        else return index < other.index;
    }
};

int findBiggerLeft(const vector<Coordinate>& coordinates, int index) {
    for (int i = index - 1; i >= 0; i--) {
        if (coordinates[i].y >= coordinates[index].y) return i;
    }

    return -1;
}

int findBiggerRight(const vector<Coordinate>& coordinates, int index) {
    for (int i = index + 1; i < coordinates.size(); i++) {
        if (coordinates[i].y >= coordinates[index].y) return i;
    }

    return -1;
}

void generateClosestVector(const vector<Coordinate>& coordinates, vector<BeforeAfter>& closestLarger) {
    int n = coordinates.size();

    for (int i = 1; i < n; i++) {
        if (coordinates[i].y <= coordinates[i - 1].y) {
            closestLarger[i].before = i-1;
        }

        else {
            int candidateIndex = closestLarger[i - 1].before;

            while (candidateIndex != -1) {
                if (coordinates[i].y <= coordinates[candidateIndex].y) {
                    closestLarger[i].before = candidateIndex;

                    break;
                }

                candidateIndex = closestLarger[candidateIndex].before;
            }
        }
    }

    for (int i = n - 2; i >= 0; i--) {
        if (coordinates[i].y <= coordinates[i + 1].y) {
            closestLarger[i].after = i+1;
        }

        else {
            int candidateIndex = closestLarger[i + 1].after;

            while (candidateIndex != -1) {
                if (coordinates[i].y <= coordinates[candidateIndex].y) {
                    closestLarger[i].after = candidateIndex;

                    break;
                }

                candidateIndex = closestLarger[candidateIndex].after;
            }
        }
    }
}

//last ditch effort: stop using structs and use uint64, sorting will work and you can decode the coordinates back
int main() {
    int n;

    cin >> n;

    vector<Coordinate> coordinates(n);

    for (int i = 0; i < n; i++) {
        cin >> coordinates[i].x;
    }

    for (int i = 0; i < n; i++) {
        cin >> coordinates[i].y;
        coordinates[i].index = i;
    }

    sort(coordinates.begin(), coordinates.end());

    vector<BeforeAfter> closestLarger(n);

    generateClosestVector(coordinates, closestLarger);

    printing = true;

    sort(coordinates.begin(), coordinates.end());

    for (int i = 0; i < n; i++) {
        if (closestLarger[i].before == -1 && closestLarger[i].after == -1) cout << -1 << endl;

        else if (closestLarger[i].before == -1) {
            const int closestLargerIndex = closestLarger[i].after;

            cout << coordinates[closestLargerIndex].x - coordinates[closestLargerIndex].y + coordinates[i].y - coordinates[i].x << endl;
        }

        else if (closestLarger[i].after == -1) {
            const int closestLargerIndex = closestLarger[i].before;

            cout << coordinates[i].x - coordinates[closestLargerIndex].x - coordinates[closestLargerIndex].y + coordinates[i].y << endl;
        }

        else {
            const int closestLargerIndexA = closestLarger[i].after;
            int da = coordinates[closestLargerIndexA].x - coordinates[closestLargerIndexA].y + coordinates[i].y - coordinates[i].x;

            const int closestLargerIndexB = closestLarger[i].before;
            int db = coordinates[i].x - coordinates[closestLargerIndexB].x - coordinates[closestLargerIndexB].y + coordinates[i].y;

            cout << min(da, db) << endl;
        }
    }

    return 0;
}